<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Log;

class StatesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $states = [
            'Amazonas', 'Anzoátegui', 'Apure', 'Aragua', 'Barinas', 'Bolívar', 'Carabobo', 'Cojedes', 'Delta Amacuro', 'Distrito Capital', 'Falcón', 'Guárico', 'Lara', 'Mérida', 'Miranda', 'Monagas', 'Nueva Esparta', 'Portuguesa', 'Sucre', 'Táchira', 'Trujillo', 'Vargas', 'Yaracuy', 'Zulia'
        ];
        
        $cities = [
            'Amazonas' => ['Puerto Ayacucho', 'San Fernando de Atabapo', 'La Esmeralda', 'Isla Ratón', 'San Juan de Manapiare', 'Maroa', 'San Carlos de Río Negro'],
            'Anzoátegui' => ['Barcelona', 'El Tigre', 'Puerto La Cruz', 'Anaco', 'Lechería', 'Cantaura', 'Pariaguán', 'Aragua de Barcelona', 'Puerto Píritu', 'Soledad'],
            'Apure' => ['San Fernando de Apure', 'Guasdualito', 'Achaguas', 'Biruaca', 'Elorza', 'San Juan de Payara', 'Bruzual'],
            'Aragua' => ['Maracay', 'Turmero', 'La Victoria', 'Cagua', 'El Limón', 'Santa Rita', 'Palo Negro', 'Villa de Cura', 'San Mateo', 'Ocumare de la Costa'],
            'Barinas' => ['Barinas', 'Sabaneta', 'Socopó', 'Barrancas', 'Santa Bárbara', 'Ciudad Bolivia', 'Libertad'],
            'Bolívar' => ['Ciudad Bolívar', 'Ciudad Guayana', 'Upata', 'Caicara del Orinoco', 'El Callao', 'Santa Elena de Uairén', 'Guasipati'],
            'Carabobo' => ['Valencia', 'Puerto Cabello', 'Guacara', 'Mariara', 'Tocuyito', 'Bejuma', 'Morón'],
            'Cojedes' => ['San Carlos', 'Tinaquillo', 'El Baúl', 'Macapo', 'El Pao'],
            'Delta Amacuro' => ['Tucupita', 'Pedernales', 'Curiapo', 'La Horqueta'],
            'Distrito Capital' => ['Caracas'],
            'Falcón' => ['Coro', 'Punto Fijo', 'Churuguara', 'Tucacas', 'Mirimire', 'La Vela de Coro'],
            'Guárico' => ['San Juan de Los Morros', 'Valle de La Pascua', 'Calabozo', 'Altagracia de Orituco', 'Zaraza', 'Tucupido'],
            'Lara' => ['Barquisimeto', 'Carora', 'El Tocuyo', 'Quíbor', 'Duaca', 'Cubiro'],
            'Mérida' => ['Mérida', 'El Vigía', 'Tovar', 'Ejido', 'Bailadores', 'Mucuchíes'],
            'Miranda' => ['Los Teques', 'Guarenas', 'Guatire', 'Santa Teresa del Tuy', 'Ocumare del Tuy', 'Charallave', 'Higuerote'],
            'Monagas' => ['Maturín', 'Caripito', 'Punta de Mata', 'Temblador', 'Caicara de Maturín'],
            'Nueva Esparta' => ['La Asunción', 'Porlamar', 'Pampatar', 'Juan Griego', 'Punta de Piedras'],
            'Portuguesa' => ['Guanare', 'Acarigua', 'Araure', 'Biscucuy', 'Ospino'],
            'Sucre' => ['Cumaná', 'Carúpano', 'Güiria', 'Río Caribe', 'Cariaco'],
            'Táchira' => ['San Cristóbal', 'Rubio', 'La Fría', 'Táriba', 'San Antonio del Táchira'],
            'Trujillo' => ['Trujillo', 'Valera', 'Boconó', 'Carache', 'Escuque'],
            'Vargas' => ['La Guaira', 'Macuto', 'Caraballeda', 'Maiquetía'],
            'Yaracuy' => ['San Felipe', 'Yaritagua', 'Chivacoa', 'Nirgua', 'Cocorote'],
            'Zulia' => ['Maracaibo', 'Cabimas', 'Ciudad Ojeda', 'Santa Bárbara del Zulia', 'Machiques', 'La Concepción']
        ];
        

foreach ($states as $state) {
    // Insertar el estado en la base de datos
    DB::table('states')->insert(['name' => $state]);
    Log::info("Estado {$state} insertado.");

    // Obtener el ID del estado recién insertado
    $estadoId = DB::getPdo()->lastInsertId();

    // Preparar las ciudades para inserción masiva
    $ciudadesParaInsertar = [];
    foreach ($cities[$state] as $city) {
        $ciudadesParaInsertar[] = ['name' => $city, 'state_id' => $estadoId];
    }

    // Insertar las ciudades de forma masiva
    DB::table('cities')->insert($ciudadesParaInsertar);
    Log::info("Ciudades para el estado {$state} insertadas.");
}
    }
}
