<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Expense_category;
use Illuminate\Http\Request;

class ExpenseCategoryController extends Controller
{
    public function getTree()
    {
        $categories = Expense_category::with('children')->whereNull('parent_id')->get();

        $tree = $this->buildTree($categories);
        return response()->json($tree, 200);
    }

    private function buildTree($categories)
    {
         return $categories->map(function ($category) {
            return [
                'key' => (string) $category->id,
                'data' => [
                    'name' => $category->name,
                    'type' => $category->type,
                    'active' => $category->active? true : false,
                ],
                'children' => $this->buildTree($category->children)
            ];
        });

    }

    public function addChild(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'parent_id' => 'required|exists:expense_category,id',
            'type' => 'nullable|string|max:255',
            'active' => 'boolean'
        ]);

        $category = Expense_category::create($request->only(['name', 'parent_id', 'type', 'active']));
        return response()->json([
            'status' => 'success',
            'category' => $category->id,
            'message' => 'Categoría creada exitosamente.'
        ], 200);
    }
}
