<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Country;
use Illuminate\Http\Request;

class CountryController extends Controller
{
    public function getAllCountries()
    {
        $countries = Country::all();
        return response()->json(
            [
                'status'    => 'success', 
                'countries' => $countries
            ], 200
        );
    }

    public function getCountries()
    {
        $countries = Country::where('active', 1)->get();
        return response()->json(
            [
                'status'    => 'success', 
                'data'      => $countries
            ], 200
        );
    }

    public function createCountry(Request $request)
    {
        $request->validate([
            'country' => 'required|string|max:255',
        ]);

        if (Country::where('country', $request->country)->exists()) {
            return response()->json([
            'status'  => 'exist',
            'message' => 'El país ya existe en otro registro.'
            ], 200);
        }

        $country = Country::create([
            'country' => $request->country,
            'active' => 1,
        ]);

        return response()->json(
            [
                'status' => 'success', 
                'data'   => $country
            ], 201
        );
    }

    public function updateCountry(Request $request, $id)
    {
        if (Country::where('country', $request->country)->where('id', '!=', $id)->exists()) {
            return response()->json([
                'status'  => 'exist',
                'message' => 'El país ya existe en otro registro.'
            ], 200);
        }

        $country = Country::findOrFail($id);

        $request->validate([
            'country' => 'required|string|max:255',
        ]);

        $country->update([
            'country' => $request->country,
            'active' => $request->active ?? 1,
        ]);

        return response()->json(
            [
                'status' => 'success', 
                'data'   => $country
            ], 200
        );
    }
}
